%This program runs the simulations behind Tables OA.1, OA.2, and OA.3 in the Online Appendix.

%It conducts 1000 experiments of 1.10^6 episodes, with 2 AMMs, Delta_v = 4
%\sigma = 5, and different pairs (alpha, beta) for both algorithms. It
%returns the average profit and max Q-value obtained by each algorithm in each episode as well as
%all the variables in the last episode.

clear

% record running time
% when producing the data the running time was 13 hours and 3 minutes
tic

%Set the parameters:
K=1000;                 %K      is the number of experiments.
T=1000000;              %T      is the number of episodes.  

%Set the value of the asset in the high/low state
vl=0;                   %value of the asset in low state
vh=4;                   %value of the asset in high state

%Set the value of the parameters of the normal distribution of L
mu_l=0;
sigma_l=5;

%Set the price grid: middle of the grid, tick size, number of prices on
%each side of the middle. Hence, there are 2*grid_size+1 prices between
%grid_middle - tick*grid_size and grid_middle+tick*grid_size.

grid_middle = 8;
grid_size= 69;  
tick= 0.1;      

% set random seed to ensure replicability
rng(1)

% define the 9 pairs available to each AMM.
alpha_l = 0.001;
alpha_m = 0.01;
alpha_h = 0.1;
beta_l = 5*10^(-6);
beta_m = 8*10^(-5);
beta_h = 3.2*10^(-4);

params = [alpha_l beta_l ; alpha_l beta_m ; alpha_l beta_h ; alpha_m beta_l ; alpha_m beta_m ; alpha_m beta_h ; alpha_h beta_l ; alpha_h beta_m ; alpha_h beta_h];

% Parallel computing initialization
delete(gcp("nocreate"));  % to close any existing pools that might be already running
myCluster = parcluster('local'); % get number of possible pools
parpool('local',8);

for i = 1:9
    for j = 1:i
%Display (i,j) to follow execution
disp([i,j])
%Call the function simulation_rep to run K experiments
[last_episodes]=simulation_rep(params(i,1),params(i,2),params(j,1),params(j,2),T,vh,vl,mu_l,sigma_l,grid_middle,tick,grid_size,K);

%Save the output in the subfolder "Data"
writematrix(last_episodes,sprintf("Data/last_episodes_%d_%d.txt",i,j));
    end
end

toc
